/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.mygdx.game.Assets;
import com.mygdx.game.Board;
import com.mygdx.game.Global;
import com.mygdx.game.Objects;
import com.mygdx.game.Scene;
import java.util.ArrayList;
import java.util.Arrays;

public class Snake {
    SpriteBatch batch;
    Assets assets;
    Scene scene;
    Board board;
    Objects objects;
    ArrayMap<String, ArrayMap<String, Texture>> snakeAssets = new ArrayMap();
    ArrayList<ArrayList<Integer>> snake = new ArrayList();
    Array<Rectangle> snakeRectangles = new Array();
    String side;
    String direction;
    String lastDirection;
    String gameOverDirection;
    String color;
    String name;

    Snake(SpriteBatch batch, Assets assets, Scene scene, Board board, Objects objects, String side) {
        this.batch = batch;
        this.assets = assets;
        this.scene = scene;
        this.board = board;
        this.objects = objects;
        for (String color : assets.snakeColors) {
            this.snakeAssets.put(color, new ArrayMap());
            for (String part : assets.snakeParts) {
                this.snakeAssets.get(color).put(part, assets.get("snake/" + color + "_" + part + ".png", Texture.class));
            }
        }
        this.side = side;
        if (this.side.equals("LEFT")) {
            this.direction = "DROITE";
            this.color = "blue";
        } else {
            this.direction = "GAUCHE";
            this.color = "red";
        }
        this.lastDirection = this.direction;
        this.gameOverDirection = this.direction;
    }

    public void initSnake() {
        if (this.side.equals("LEFT")) {
            this.addPart(0, this.scene.lines - 1, true);
        } else {
            this.addPart(this.scene.columns - 1, 0, true);
        }
    }

    public void initSnakeTournament() {
        if (this.side.equals("LEFT")) {
            this.addPart(2, 2, true);
        } else {
            this.addPart(19, 9, true);
        }
    }

    public boolean move(boolean grow) {
        ArrayList<Integer> futureHead = this.futureHead(this.direction);
        String futureResult = this.previewGameOver(futureHead, grow);
        if (futureResult.equals("NOTHING") || futureResult.equals("STRAWBERRY")) {
            if (futureResult.equals("STRAWBERRY")) {
                this.objects.removeStrawberry(futureHead);
                if (this.snake.size() > 1) {
                    this.removeLast();
                }
            }
            this.addPart(futureHead.get(0), futureHead.get(1), true);
            if (!grow) {
                this.removeLast();
            }
            return true;
        }
        this.gameOverDirection = this.direction;
        this.direction = this.lastDirection;
        return false;
    }

    public ArrayList<Integer> futureHead(String givenDirection) {
        ArrayList<Integer> currentHead = this.snake.get(0);
        switch (givenDirection) {
            case "HAUT": {
                return Global.tuple(currentHead.get(0), currentHead.get(1) + 1);
            }
            case "BAS": {
                return Global.tuple(currentHead.get(0), currentHead.get(1) - 1);
            }
            case "GAUCHE": {
                return Global.tuple(currentHead.get(0) - 1, currentHead.get(1));
            }
        }
        return Global.tuple(currentHead.get(0) + 1, currentHead.get(1));
    }

    public String previewGameOver(ArrayList<Integer> futureHead, boolean grow) {
        if (this.board.usedPositions.contains(futureHead)) {
            if (this.snake.size() != 2 && futureHead.equals(this.snake.get(this.snake.size() - 1)) && !grow) {
                return "NOTHING";
            }
            if (this.objects.strawberries.contains(futureHead)) {
                return "STRAWBERRY";
            }
            return "TOUCHED";
        }
        if (this.board.outsideLimits.contains(futureHead)) {
            return "TOUCHED";
        }
        return "NOTHING";
    }

    public boolean isBlocked(boolean grow) {
        ArrayList<ArrayList> tupleList = new ArrayList<ArrayList>(Arrays.asList(this.futureHead("GAUCHE"), this.futureHead("DROITE"), this.futureHead("HAUT"), this.futureHead("BAS")));
        for (ArrayList pos : tupleList) {
            String futureResult = this.previewGameOver(pos, grow);
            if (!futureResult.equals("NOTHING") && !futureResult.equals("STRAWBERRY")) continue;
            return false;
        }
        return true;
    }

    public void setDirection(String newDirection) {
        this.lastDirection = this.direction;
        this.direction = newDirection;
    }

    public void addPart(int x, int y, boolean addStart) {
        if (addStart) {
            this.snake.add(0, Global.tuple(x, y));
            this.snakeRectangles.insert(0, new Rectangle(this.scene.xOff + (float)x * this.scene.pixelsForTile, this.scene.yOff + (float)y * this.scene.pixelsForTile, this.scene.pixelsForTile, this.scene.pixelsForTile));
        } else {
            this.snake.add(Global.tuple(x, y));
            this.snakeRectangles.add(new Rectangle(this.scene.xOff + (float)x * this.scene.pixelsForTile, this.scene.yOff + (float)y * this.scene.pixelsForTile, this.scene.pixelsForTile, this.scene.pixelsForTile));
        }
        this.board.addElement(Global.tuple(x, y));
    }

    public void removeLast() {
        ArrayList<Integer> removed = this.snake.remove(this.snake.size() - 1);
        this.snakeRectangles.removeIndex(this.snakeRectangles.size - 1);
        this.board.removeElement(removed);
    }

    public void drawSnake() {
        for (int i = 0; i < this.snakeRectangles.size; ++i) {
            Rectangle part = this.snakeRectangles.get(i);
            Texture texture = this.getCorrectTexture(i);
            this.batch.draw(texture, part.x, part.y, part.width, part.height);
        }
    }

    public Texture getCorrectTexture(int index) {
        if (index == 0) {
            return this.getHead();
        }
        if (index == this.snakeRectangles.size - 1) {
            return this.getTail();
        }
        return this.getMiddlePart(index);
    }

    public Texture getHead() {
        switch (this.direction) {
            case "HAUT": {
                return this.snakeAssets.get(this.color).get("headHaut");
            }
            case "DROITE": {
                return this.snakeAssets.get(this.color).get("headDroite");
            }
            case "BAS": {
                return this.snakeAssets.get(this.color).get("headBas");
            }
        }
        return this.snakeAssets.get(this.color).get("headGauche");
    }

    public Texture getTail() {
        Rectangle part = this.snakeRectangles.get(this.snakeRectangles.size - 1);
        Rectangle beforePart = this.snakeRectangles.get(this.snakeRectangles.size - 2);
        if (beforePart.x < part.x) {
            return this.snakeAssets.get(this.color).get("tailGauche");
        }
        if (beforePart.x > part.x) {
            return this.snakeAssets.get(this.color).get("tailDroite");
        }
        if (beforePart.y < part.y) {
            return this.snakeAssets.get(this.color).get("tailBas");
        }
        return this.snakeAssets.get(this.color).get("tailHaut");
    }

    public Texture getMiddlePart(int index) {
        Rectangle part = this.snakeRectangles.get(index);
        Rectangle beforePart = this.snakeRectangles.get(index - 1);
        Rectangle afterPart = this.snakeRectangles.get(index + 1);
        if (beforePart.x < part.x && afterPart.x > part.x || beforePart.x > part.x && afterPart.x < part.x) {
            return this.snakeAssets.get(this.color).get("hori");
        }
        if (beforePart.y < part.y && afterPart.y > part.y || beforePart.y > part.y && afterPart.y < part.y) {
            return this.snakeAssets.get(this.color).get("verti");
        }
        if (beforePart.x < part.x && afterPart.y > part.y || beforePart.y > part.y && afterPart.x < part.x) {
            return this.snakeAssets.get(this.color).get("gaucheHaut");
        }
        if (beforePart.x < part.x && afterPart.y < part.y || beforePart.y < part.y && afterPart.x < part.x) {
            return this.snakeAssets.get(this.color).get("gaucheBas");
        }
        if (beforePart.x > part.x && afterPart.y > part.y || beforePart.y > part.y && afterPart.x > part.x) {
            return this.snakeAssets.get(this.color).get("droiteHaut");
        }
        return this.snakeAssets.get(this.color).get("droiteBas");
    }
}

