/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.TimeUtils;
import com.mygdx.game.Assets;
import java.util.ArrayList;

public class Scene {
    SpriteBatch batch;
    Assets assets;
    ShapeRenderer shapeRenderer;
    FreeTypeFontGenerator generator;
    FreeTypeFontGenerator.FreeTypeFontParameter parameter;
    BitmapFont titleFont;
    BitmapFont writingFont;
    BitmapFont gameInfosFont;
    BitmapFont littleGameInfosFont;
    BitmapFont leftPlayerFont;
    BitmapFont rightPlayerFont;
    GlyphLayout layout;
    Stage stage;
    Skin skin;
    ArrayList<Actor> widgets = new ArrayList();
    TextField columnsField;
    TextField linesField;
    TextField nField;
    TextField codeChannelReadField;
    TextField codeChannelWriteField;
    TextButton radioJVJ;
    TextButton radioJVIA;
    TextButton radioIAVIA;
    TextButton radioJ1;
    TextButton radioJ2;
    TextButton playButton;
    ButtonGroup<Button> radioGroup;
    ButtonGroup<Button> playerGroup;
    int lines = 16;
    int columns = 16;
    int min = 16;
    int max = 16;
    int n = 2;
    String codeChannelRead = "";
    String codeChannelWrite = "";
    boolean onlinePlayFirst = true;
    boolean isSoundOn = true;
    boolean isStrawberryOn = true;
    boolean isRockOn = true;
    boolean firstMenuToggle = true;
    boolean menuToggle = true;
    boolean gameOn = false;
    boolean playButtonPressed = false;
    boolean isLeftPlaying = false;
    boolean isBlinking = false;
    String leftPlayer = "";
    String rightPlayer = "";
    String mainText = "Snake Blockade";
    String selectedMod = null;
    String playerWon = null;
    long lastNanoBlink = TimeUtils.nanoTime();
    float pixelsForTile = 560.0f / (float)this.max;
    float xOff = this.pixelsForTile * (float)(this.max - this.columns) / 2.0f;
    float yOff = this.pixelsForTile * (float)(this.max - this.lines) / 2.0f;
    ArrayList<ArrayList<Float>> crossList = new ArrayList();
    Rectangle board = new Rectangle(0.0f, 0.0f, 560.0f, 560.0f);
    Rectangle ban = new Rectangle(0.0f, 560.0f, 560.0f, 80.0f);
    Rectangle menu;
    Rectangle sound;
    Color darkGreen;
    Color transparentBlack;
    Color clearTileGreen;
    Color darkTileGreen;

    Scene(SpriteBatch batch, Assets assets) {
        this.menu = new Rectangle(this.ban.width / 2.0f - 65.0f, this.board.height + 5.0f, 25.0f, 25.0f);
        this.sound = new Rectangle(this.menu.x + 25.0f + 10.0f, this.menu.y, this.menu.width, this.menu.height);
        this.darkGreen = Color.valueOf("547436");
        this.transparentBlack = new Color(0.0f, 0.0f, 0.0f, 0.8f);
        this.clearTileGreen = Color.valueOf("ADDD46");
        this.darkTileGreen = Color.valueOf("98CB40");
        this.batch = batch;
        this.assets = assets;
        this.shapeRenderer = new ShapeRenderer();
        this.parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        this.titleFont = this.createFont("fonts/joystix_monospace.otf", 30, Color.WHITE);
        this.writingFont = this.createFont("fonts/arial.ttf", 18, Color.WHITE);
        this.gameInfosFont = this.createFont("fonts/joystix_monospace.otf", 14, Color.WHITE);
        this.littleGameInfosFont = this.createFont("fonts/joystix_monospace.otf", 14, Color.LIGHT_GRAY);
        this.leftPlayerFont = this.createFont("fonts/joystix_monospace.otf", 20, Color.SKY);
        this.rightPlayerFont = this.createFont("fonts/joystix_monospace.otf", 20, Color.RED);
        this.layout = new GlyphLayout();
        this.stage = new Stage();
        Gdx.input.setInputProcessor(this.stage);
        this.skin = new Skin(Gdx.files.internal("skins/gdx-holo/skin/uiskin.json"));
        this.radioGroup = new ButtonGroup();
        this.radioGroup.setMaxCheckCount(1);
        this.radioGroup.setMinCheckCount(1);
        this.radioGroup.setUncheckLast(true);
        this.playerGroup = new ButtonGroup();
        this.playerGroup.setMaxCheckCount(1);
        this.playerGroup.setMinCheckCount(1);
        this.radioGroup.setUncheckLast(true);
        this.createWidgets();
    }

    public void menuDesign() {
        this.drawRect(0.0f, 0.0f, this.board.width, this.board.height, this.transparentBlack, true, true);
        this.drawLabels();
        if (this.firstMenuToggle) {
            this.addToStage(this.stage, this.widgets);
            this.firstMenuToggle = false;
        }
    }

    public void drawBoard() {
        this.batch.draw(this.assets.get("design/bg.png", Texture.class), 0.0f, 0.0f, this.board.width, this.board.height);
        this.batch.end();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Color columnFirstColor = this.clearTileGreen;
        for (int i = 0; i < this.columns; ++i) {
            Color rowFirstColor = columnFirstColor;
            for (int j = 0; j < this.lines; ++j) {
                this.drawRect(this.xOff + (float)i * this.pixelsForTile, this.yOff + (float)j * this.pixelsForTile, this.pixelsForTile, this.pixelsForTile, rowFirstColor, false, false);
                rowFirstColor = this.changeTileColor(rowFirstColor);
            }
            columnFirstColor = this.changeTileColor(columnFirstColor);
        }
        this.shapeRenderer.end();
        this.batch.begin();
    }

    public void drawCross() {
        for (ArrayList<Float> pos : this.crossList) {
            this.batch.draw(this.assets.get("design/cross.png", Texture.class), this.xOff + pos.get(0).floatValue() * this.pixelsForTile, this.yOff + pos.get(1).floatValue() * this.pixelsForTile, this.pixelsForTile, this.pixelsForTile);
        }
    }

    public void drawBan() {
        this.drawRect(this.ban.x, this.ban.y, this.ban.width, this.ban.height, this.darkGreen, true, false);
        this.gameInfos();
        this.drawGameIcons();
        this.showPlayersAvatars();
        this.showPlayersNames();
        if (!this.gameOn && this.playerWon != null) {
            this.showPlayerTrophy(this.playerWon);
        }
    }

    public void gameInfos() {
        this.layout.setText(this.gameInfosFont, "N = " + this.n);
        this.gameInfosFont.draw((Batch)this.batch, this.layout, this.ban.width / 2.0f - this.layout.width / 2.0f, 635.0f);
        this.layout.setText(this.littleGameInfosFont, "R: " + this.codeChannelRead);
        this.littleGameInfosFont.draw((Batch)this.batch, this.layout, this.ban.width / 2.0f - this.layout.width / 2.0f, 640.0f - this.layout.height - 10.0f);
        this.layout.setText(this.littleGameInfosFont, "W: " + this.codeChannelWrite);
        this.littleGameInfosFont.draw((Batch)this.batch, this.layout, this.ban.width / 2.0f - this.layout.width / 2.0f, 640.0f - this.layout.height * 2.0f - 15.0f);
        this.drawRect(this.ban.width / 2.0f - 80.0f, this.board.height + 6.0f, 1.0f, this.ban.height - 12.0f, Color.WHITE, true, false);
        this.drawRect(this.ban.width / 2.0f + 80.0f, this.board.height + 6.0f, 1.0f, this.ban.height - 12.0f, Color.WHITE, true, false);
    }

    public void drawGameIcons() {
        this.batch.draw(this.assets.get("design/esc.png", Texture.class), this.menu.x, this.menu.y, this.menu.width, this.menu.height);
        this.batch.draw(this.assets.get("design/sound.png", Texture.class), this.sound.x, this.sound.y, this.sound.width, this.sound.height);
        this.batch.draw(this.assets.get("objects/strawberry.png", Texture.class), this.sound.x + 25.0f + 10.0f, this.sound.y, this.sound.width, this.sound.height);
        this.batch.draw(this.assets.get("objects/rock.png", Texture.class), this.sound.x + 50.0f + 20.0f, this.sound.y, this.sound.width, this.sound.height);
        Texture stop = this.assets.get("design/cross.png", Texture.class);
        if (!this.isSoundOn) {
            this.batch.draw(stop, this.sound.x, this.sound.y, this.sound.width, this.sound.height);
        }
        if (!this.isStrawberryOn) {
            this.batch.draw(stop, this.sound.x + 25.0f + 10.0f, this.sound.y, this.sound.width, this.sound.height);
        }
        if (!this.isRockOn) {
            this.batch.draw(stop, this.sound.x + 50.0f + 20.0f, this.sound.y, this.sound.width, this.sound.height);
        }
    }

    public void showPlayersAvatars() {
        this.batch.draw(this.assets.get("snake/blue_headBas.png", Texture.class), this.ban.width / 4.0f - 17.5f - 35.0f, 600.0f);
        this.batch.draw(this.assets.get("snake/red_headBas.png", Texture.class), this.ban.width / 4.0f * 3.0f - 17.5f + 35.0f, 600.0f);
    }

    public void showPlayersNames() {
        if (!(this.isBlinking && this.isLeftPlaying && this.gameOn)) {
            this.layout.setText(this.leftPlayerFont, this.leftPlayer);
            this.leftPlayerFont.draw((Batch)this.batch, this.layout, this.ban.width / 4.0f - this.layout.width / 2.0f - 35.0f, 600.0f - this.layout.height + 5.0f);
        }
        if (!this.isBlinking || this.isLeftPlaying || !this.gameOn) {
            this.layout.setText(this.rightPlayerFont, this.rightPlayer);
            this.rightPlayerFont.draw((Batch)this.batch, this.layout, this.ban.width / 4.0f * 3.0f - this.layout.width / 2.0f + 35.0f, 600.0f - this.layout.height + 5.0f);
        }
        if (TimeUtils.nanoTime() - this.lastNanoBlink > 500000000L) {
            this.isBlinking = !this.isBlinking;
            this.lastNanoBlink = TimeUtils.nanoTime();
        }
    }

    public void showPlayerTrophy(String side) {
        Texture texture = this.assets.get("design/trophy.png", Texture.class);
        if (side.equals("LEFT")) {
            this.batch.draw(texture, 15.0f, 640.0f - this.ban.height / 2.0f - (float)texture.getHeight() / 2.0f);
        }
        if (side.equals("RIGHT")) {
            this.batch.draw(texture, this.ban.width - (float)texture.getWidth() - 15.0f, 640.0f - this.ban.height / 2.0f - (float)texture.getHeight() / 2.0f);
        }
    }

    public void drawLabels() {
        this.mainTitle();
        this.showControls();
        this.showControls();
        this.modsText();
        this.drawFieldsTexts();
        this.drawStage();
    }

    public void mainTitle() {
        this.layout.setText(this.titleFont, this.mainText);
        this.titleFont.draw((Batch)this.batch, this.layout, this.board.width / 2.0f - this.layout.width / 2.0f, this.board.height - 20.0f);
    }

    public void showControls() {
        this.j1ControlsImage();
        this.j2ControlsImage();
    }

    public void j1ControlsImage() {
        this.layout.setText(this.leftPlayerFont, "J1");
        this.leftPlayerFont.draw((Batch)this.batch, this.layout, 50.0f, this.board.height - 80.0f);
        Texture img = this.assets.get("design/zqsd.png", Texture.class);
        float ratio = (float)img.getHeight() / (float)img.getWidth();
        this.batch.draw(img, 40.0f, this.board.height - 200.0f, 190.0f, 200.0f * ratio);
    }

    public void j2ControlsImage() {
        this.layout.setText(this.rightPlayerFont, "J2");
        this.rightPlayerFont.draw((Batch)this.batch, this.layout, this.board.width - 50.0f - this.layout.width, this.board.height - 80.0f);
        Texture img = this.assets.get("design/fleches.png", Texture.class);
        float ratio = (float)img.getHeight() / (float)img.getWidth();
        this.batch.draw(img, this.board.width - 40.0f - (float)img.getWidth() / 2.0f, this.board.height - 190.0f, 200.0f, 200.0f * ratio);
    }

    public void modsText() {
        this.layout.setText(this.writingFont, "Modes :");
        this.writingFont.draw((Batch)this.batch, this.layout, this.board.width / 2.0f - this.layout.width / 2.0f, this.board.height - 215.0f);
    }

    public void drawFieldsTexts() {
        this.layout.setText(this.writingFont, "X*X cases =");
        this.writingFont.draw((Batch)this.batch, this.layout, 10.0f, this.board.height - 370.0f);
        this.drawRect(140.0f, this.board.height - 370.0f - this.layout.height - 2.0f, 50.0f, 1.0f, Color.WHITE, true, false);
        this.layout.setText(this.writingFont, "x");
        this.writingFont.draw((Batch)this.batch, this.layout, 205.0f - this.layout.width / 2.0f, this.board.height - 370.0f);
        this.drawRect(220.0f, this.board.height - 370.0f - this.layout.height - 2.0f, 50.0f, 1.0f, Color.WHITE, true, false);
        this.layout.setText(this.writingFont, "N =");
        this.writingFont.draw((Batch)this.batch, this.layout, this.board.width / 2.0f + 10.0f, this.board.height - 370.0f);
        this.drawRect(this.board.width / 2.0f + 140.0f, this.board.height - 370.0f - this.layout.height - 2.0f, 130.0f, 1.0f, Color.WHITE, true, false);
        this.layout.setText(this.writingFont, "Channel read =");
        this.writingFont.draw((Batch)this.batch, this.layout, 10.0f, this.board.height - 410.0f);
        this.drawRect(140.0f, this.board.height - 410.0f - this.layout.height - 2.0f, 130.0f, 1.0f, Color.WHITE, true, false);
        this.layout.setText(this.writingFont, "Channel write =");
        this.writingFont.draw((Batch)this.batch, this.layout, this.board.width / 2.0f + 10.0f, this.board.height - 410.0f);
        this.drawRect(this.board.width / 2.0f + 140.0f, this.board.height - 410.0f - this.layout.height - 2.0f, 130.0f, 1.0f, Color.WHITE, true, false);
    }

    public void drawStage() {
        this.stage.act(Gdx.graphics.getDeltaTime());
        this.stage.draw();
    }

    public void createWidgets() {
        this.radioJVJ = this.createRadioButton(this.widgets, this.radioGroup, "Joueur VS Joueur", this.board.width / 2.0f - 250.0f - 10.0f, this.board.height - 300.0f, 250.0f);
        this.radioJVIA = this.createRadioButton(this.widgets, this.radioGroup, "Joueur VS IA", this.board.width / 2.0f - 250.0f - 10.0f, this.board.height - 350.0f, 250.0f);
        this.radioIAVIA = this.createRadioButton(this.widgets, this.radioGroup, "[EN LIGNE] IA VS IA", this.board.width / 2.0f + 10.0f, this.board.height - 300.0f, 250.0f);
        this.columnsField = this.createTextField(this.widgets, Integer.toString(this.columns), 130.0f, this.board.height - 370.0f - 20.0f, 70.0f, 30.0f);
        this.onlyNumbersFilter(this.columnsField);
        this.linesField = this.createTextField(this.widgets, Integer.toString(this.lines), 210.0f, this.board.height - 370.0f - 20.0f, 70.0f, 30.0f);
        this.onlyNumbersFilter(this.linesField);
        this.nField = this.createTextField(this.widgets, Integer.toString(this.n), this.board.width / 2.0f + 140.0f - 10.0f, this.board.height - 370.0f - 20.0f, 150.0f, 30.0f);
        this.onlyNumbersFilter(this.nField);
        this.codeChannelReadField = this.createTextField(this.widgets, "", 130.0f, this.board.height - 410.0f - 20.0f, 150.0f, 30.0f);
        this.codeChannelWriteField = this.createTextField(this.widgets, "", this.board.width / 2.0f + 140.0f - 10.0f, this.board.height - 410.0f - 20.0f, 150.0f, 30.0f);
        this.radioJ1 = this.createRadioButton(this.widgets, this.playerGroup, "J1 (2, 2)", this.board.width / 2.0f - 250.0f - 10.0f, this.board.height - 490.0f, 250.0f);
        this.radioJ2 = this.createRadioButton(this.widgets, this.playerGroup, "J2 (9, 19)", this.board.width / 2.0f + 10.0f, this.board.height - 490.0f, 250.0f);
        this.playButton = this.createClickableButton(this.widgets, "Jouer", this.board.width / 2.0f - 75.0f, 10.0f, 150.0f, 50.0f);
        this.startGameButtonEventListener(this.playButton);
    }

    public void setPlayersNames(String leftName, String rightName) {
        this.leftPlayer = leftName;
        this.rightPlayer = rightName;
    }

    public void startGameButtonActions() {
        int tempNb;
        if (!this.columnsField.getText().isEmpty() && (tempNb = Integer.parseInt(this.columnsField.getText())) >= 2 && tempNb <= 300) {
            this.setColumns(tempNb);
        }
        if (!this.linesField.getText().isEmpty() && (tempNb = Integer.parseInt(this.linesField.getText())) >= 2 && tempNb <= 300) {
            this.setLines(tempNb);
        }
        if (!this.nField.getText().isEmpty() && (tempNb = Integer.parseInt(this.nField.getText())) >= 1) {
            this.n = tempNb;
        }
        if (!this.codeChannelReadField.getText().isEmpty()) {
            this.codeChannelRead = this.codeChannelReadField.getText();
        }
        if (!this.codeChannelWriteField.getText().isEmpty()) {
            this.codeChannelWrite = this.codeChannelWriteField.getText();
        }
        this.disableObjects();
        if (this.radioGroup.getChecked() == this.radioJVJ) {
            this.selectedMod = "JVJ";
            this.enableObjects();
        } else if (this.radioGroup.getChecked() == this.radioJVIA) {
            this.selectedMod = "JVIA";
        } else if (this.radioGroup.getChecked() == this.radioIAVIA) {
            this.selectedMod = "IAVIA";
            this.isRockOn = true;
            this.n = 4;
            this.setColumns(22);
            this.setLines(12);
            this.onlinePlayFirst = this.playerGroup.getChecked() == this.radioJ1;
        }
        this.playButtonPressed = true;
        this.menuToggle = false;
        this.gameOn = true;
        this.isLeftPlaying = true;
        this.mainText = "Pause";
        this.crossList.clear();
        this.stage.clear();
    }

    private void drawRect(float x, float y, float width, float height, Color color, boolean autoSetShape, boolean enableBlend) {
        if (autoSetShape) {
            this.batch.end();
            if (enableBlend) {
                Gdx.gl.glEnable(3042);
                Gdx.gl.glBlendFunc(770, 771);
            }
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        }
        this.shapeRenderer.setColor(color);
        this.shapeRenderer.rect(x, y, width, height);
        if (autoSetShape) {
            this.shapeRenderer.end();
            if (enableBlend) {
                Gdx.gl.glDisable(3042);
            }
            this.batch.begin();
        }
    }

    private TextField createTextField(ArrayList<Actor> actors, String baseText, float x, float y, float width, float height) {
        TextField textField = new TextField(baseText, this.skin);
        textField.setColor(Color.WHITE);
        textField.setPosition(x, y);
        textField.setSize(width, height);
        actors.add(textField);
        return textField;
    }

    private TextButton createRadioButton(ArrayList<Actor> actors, ButtonGroup<Button> buttonGroup, String baseText, float x, float y, float width) {
        TextButton radioButton = new TextButton(baseText, this.skin, "toggle");
        radioButton.setWidth(width);
        radioButton.setPosition(x, y);
        buttonGroup.add(radioButton);
        actors.add(radioButton);
        return radioButton;
    }

    private TextButton createClickableButton(ArrayList<Actor> actors, String baseText, float x, float y, float width, float height) {
        TextButton clickableButton = new TextButton(baseText, this.skin);
        clickableButton.setSize(width, height);
        clickableButton.setPosition(x, y);
        actors.add(clickableButton);
        return clickableButton;
    }

    private void addToStage(Stage stage, ArrayList<Actor> actors) {
        for (Actor actor : actors) {
            stage.addActor(actor);
        }
    }

    private BitmapFont createFont(String path, int size, Color color) {
        if (this.generator != null) {
            this.generator.dispose();
            this.generator = null;
        }
        this.generator = new FreeTypeFontGenerator(Gdx.files.internal(path));
        this.parameter.size = size;
        this.parameter.color = color;
        return this.generator.generateFont(this.parameter);
    }

    private Color changeTileColor(Color color) {
        if (color == this.clearTileGreen) {
            return this.darkTileGreen;
        }
        return this.clearTileGreen;
    }

    private void enableObjects() {
        this.isStrawberryOn = true;
        this.isRockOn = true;
    }

    private void disableObjects() {
        this.isStrawberryOn = false;
        this.isRockOn = false;
    }

    private void setColumns(int val) {
        this.columns = val;
        this.updateRatios();
    }

    private void setLines(int val) {
        this.lines = val;
        this.updateRatios();
    }

    private void updateRatios() {
        this.min = Math.min(this.columns, this.lines);
        this.max = Math.max(this.columns, this.lines);
        this.pixelsForTile = 560.0f / (float)this.max;
        this.xOff = this.pixelsForTile * (float)(this.max - this.columns) / 2.0f;
        this.yOff = this.pixelsForTile * (float)(this.max - this.lines) / 2.0f;
    }

    private void onlyNumbersFilter(TextField textField) {
        textField.setTextFieldFilter(new TextField.TextFieldFilter(){

            @Override
            public boolean acceptChar(TextField textField, char c) {
                return Character.isDigit(c);
            }
        });
    }

    private void startGameButtonEventListener(TextButton button) {
        button.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Scene.this.startGameButtonActions();
            }
        });
    }

    private void disposeFonts() {
        this.titleFont.dispose();
        this.writingFont.dispose();
        this.gameInfosFont.dispose();
        this.littleGameInfosFont.dispose();
        this.leftPlayerFont.dispose();
        this.rightPlayerFont.dispose();
    }

    public void dispose() {
        this.shapeRenderer.dispose();
        if (this.generator != null) {
            this.generator.dispose();
        }
        this.disposeFonts();
        this.stage.dispose();
        this.skin.dispose();
    }
}

