/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.mygdx.game.Assets;
import com.mygdx.game.Board;
import com.mygdx.game.Global;
import com.mygdx.game.Scene;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class Objects {
    SpriteBatch batch;
    Assets assets;
    Scene scene;
    Board board;
    Random random;
    ArrayList<ArrayList<Integer>> strawberries = new ArrayList();
    Array<Rectangle> strawberriesRectangles = new Array();
    ArrayList<ArrayList<Integer>> rocks = new ArrayList();
    Array<Rectangle> rocksRectangles = new Array();
    Texture strawberryTexture;
    Texture rockTexture;
    boolean objectsEnabled = true;

    Objects(SpriteBatch batch, Assets assets, Scene scene, Board board) {
        this.batch = batch;
        this.assets = assets;
        this.scene = scene;
        this.board = board;
        this.random = new Random();
        this.strawberryTexture = assets.get("objects/strawberry.png", Texture.class);
        this.rockTexture = assets.get("objects/rock.png", Texture.class);
    }

    public void initObjects(int nbStrawberries, int nbRocks) {
        int i;
        for (i = 0; i < nbRocks; ++i) {
            this.addRock();
        }
        for (i = 0; i < nbStrawberries; ++i) {
            this.addStrawberry();
        }
    }

    public void drawObjects() {
        this.drawStrawberries();
        this.drawRocks();
    }

    public void drawStrawberries() {
        for (Rectangle strawberryRect : this.strawberriesRectangles) {
            this.batch.draw(this.strawberryTexture, strawberryRect.x, strawberryRect.y, strawberryRect.width, strawberryRect.height);
        }
    }

    public void drawRocks() {
        for (Rectangle rockRect : this.rocksRectangles) {
            this.batch.draw(this.rockTexture, rockRect.x, rockRect.y, rockRect.width, rockRect.height);
        }
    }

    public void addStrawberry() {
        if (this.objectsEnabled) {
            try {
                ArrayList<Integer> coor = this.board.unusedPositionsWIP.get(this.random.nextInt(this.board.unusedPositionsWIP.size()));
                this.strawberries.add(coor);
                this.board.addElement(coor);
                this.strawberriesRectangles.add(new Rectangle(this.scene.xOff + this.scene.pixelsForTile * (float)coor.get(0).intValue(), this.scene.yOff + this.scene.pixelsForTile * (float)coor.get(1).intValue(), this.scene.pixelsForTile, this.scene.pixelsForTile));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void addRock() {
        if (this.objectsEnabled) {
            try {
                ArrayList<Integer> coor = this.board.unusedPositionsWIP.get(this.random.nextInt(this.board.unusedPositionsWIP.size()));
                this.rocks.add(coor);
                this.board.addElement(coor);
                this.rocksRectangles.add(new Rectangle(this.scene.xOff + this.scene.pixelsForTile * (float)coor.get(0).intValue(), this.scene.yOff + this.scene.pixelsForTile * (float)coor.get(1).intValue(), this.scene.pixelsForTile, this.scene.pixelsForTile));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void addRocksTournament() {
        this.objectsEnabled = true;
        ArrayList<ArrayList> listOfRocks = new ArrayList<ArrayList>(Arrays.asList(Global.tuple(4, 4), Global.tuple(4, 5), Global.tuple(4, 6), Global.tuple(4, 7), Global.tuple(17, 4), Global.tuple(17, 5), Global.tuple(17, 6), Global.tuple(17, 7)));
        for (ArrayList rock : listOfRocks) {
            this.rocks.add(rock);
            this.board.addElement(rock);
            this.rocksRectangles.add(new Rectangle(this.scene.xOff + this.scene.pixelsForTile * (float)((Integer)rock.get(0)).intValue(), this.scene.yOff + this.scene.pixelsForTile * (float)((Integer)rock.get(1)).intValue(), this.scene.pixelsForTile, this.scene.pixelsForTile));
        }
        this.objectsEnabled = false;
    }

    public void removeStrawberry(ArrayList<Integer> coor) {
        if (this.objectsEnabled) {
            this.strawberries.remove(coor);
            this.board.removeElement(coor);
            for (Rectangle strawberryRect : this.strawberriesRectangles) {
                if (this.scene.xOff + (float)coor.get(0).intValue() * this.scene.pixelsForTile != strawberryRect.x || this.scene.yOff + (float)coor.get(1).intValue() * this.scene.pixelsForTile != strawberryRect.y) continue;
                this.strawberriesRectangles.removeValue(strawberryRect, true);
            }
        }
    }
}

