/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mygdx.game.Assets;
import com.mygdx.game.Board;
import com.mygdx.game.Objects;
import com.mygdx.game.Scene;
import com.mygdx.game.Snake;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;

public class IAG20
extends Snake {
    Snake otherSnake = null;
    Board board;
    Random random;

    IAG20(SpriteBatch batch, Assets assets, Scene scene, Board board, Objects objects, String side) {
        super(batch, assets, scene, board, objects, side);
        this.board = board;
        this.random = new Random();
    }

    void evaluate() {
        ArrayList<String> possibleDirections = this.getPossibleDirections();
        if (possibleDirections.isEmpty()) {
            possibleDirections = this.getAllDirections();
        }
        String bestDirection = this.chooseBestDirection(possibleDirections);
        this.setDirection(bestDirection);
    }

    ArrayList<String> getPossibleDirections() {
        ArrayList<String> directions = this.getAllDirections();
        directions.removeIf(direction -> !this.isValidDirection((String)direction));
        return directions;
    }

    ArrayList<String> getAllDirections() {
        ArrayList<String> directions = new ArrayList<String>();
        directions.add("HAUT");
        directions.add("BAS");
        directions.add("GAUCHE");
        directions.add("DROITE");
        return directions;
    }

    boolean isValidDirection(String direction) {
        ArrayList<Integer> futureHead = this.futureHead(direction);
        String result = this.previewGameOver(futureHead, false);
        boolean collideSelf = this.snake.stream().skip(1L).anyMatch(part -> part.equals(futureHead));
        boolean collideOtherSnake = this.otherSnake != null && this.otherSnake.snake.stream().anyMatch(part -> part.equals(futureHead));
        return result.equals("NOTHING") && !collideSelf && !collideOtherSnake;
    }

    boolean isPositionFree(ArrayList<Integer> position) {
        String result = this.previewGameOver(position, false);
        boolean collideSelf = this.snake.stream().anyMatch(part -> part.equals(position));
        boolean collideOtherSnake = this.otherSnake != null && this.otherSnake.snake.stream().anyMatch(part -> part.equals(position));
        return result.equals("NOTHING") && !collideSelf && !collideOtherSnake;
    }

    String chooseBestDirection(ArrayList<String> possibleDirections) {
        ArrayList<String> bestDirections = new ArrayList<String>();
        int maxFreeSpace = -1;
        for (String direction : possibleDirections) {
            ArrayList<Integer> futureHead = this.futureHead(direction);
            int freeSpace = this.countFreeSpaces(futureHead);
            if (freeSpace > maxFreeSpace) {
                maxFreeSpace = freeSpace;
                bestDirections.clear();
                bestDirections.add(direction);
                continue;
            }
            if (freeSpace != maxFreeSpace) continue;
            bestDirections.add(direction);
        }
        if (bestDirections.size() > 1) {
            int minDistance = Integer.MAX_VALUE;
            ArrayList<String> bestDirectionsWithMinDistance = new ArrayList<String>();
            for (String direction : bestDirections) {
                ArrayList<Integer> futureHead = this.futureHead(direction);
                int distance = this.calculateManhattanDistance(futureHead, this.otherSnake.snake.get(0));
                if (distance < minDistance) {
                    minDistance = distance;
                    bestDirectionsWithMinDistance.clear();
                    bestDirectionsWithMinDistance.add(direction);
                    continue;
                }
                if (distance != minDistance) continue;
                bestDirectionsWithMinDistance.add(direction);
            }
            return (String)bestDirectionsWithMinDistance.get(this.random.nextInt(bestDirectionsWithMinDistance.size()));
        }
        return (String)bestDirections.get(0);
    }

    int calculateManhattanDistance(ArrayList<Integer> position1, ArrayList<Integer> position2) {
        return Math.abs(position1.get(0) - position2.get(0)) + Math.abs(position1.get(1) - position2.get(1));
    }

    int countFreeSpaces(ArrayList<Integer> start) {
        HashSet<ArrayList<Integer>> visited = new HashSet<ArrayList<Integer>>();
        ArrayList<ArrayList<Integer>> queue = new ArrayList<ArrayList<Integer>>();
        queue.add(start);
        visited.add(start);
        int freeSpaces = 0;
        while (!queue.isEmpty()) {
            ArrayList position = (ArrayList)queue.remove(0);
            ++freeSpaces;
            for (String direction : this.getAllDirections()) {
                ArrayList<Integer> nextPos = this.futureHeadFromPosition(position, direction);
                if (!this.isPositionFree(nextPos) || visited.contains(nextPos)) continue;
                queue.add(nextPos);
                visited.add(nextPos);
            }
        }
        return freeSpaces;
    }

    ArrayList<Integer> futureHeadFromPosition(ArrayList<Integer> position, String direction) {
        ArrayList<Integer> newHead = new ArrayList<Integer>(position);
        switch (direction) {
            case "HAUT": {
                newHead.set(1, newHead.get(1) + 1);
                break;
            }
            case "BAS": {
                newHead.set(1, newHead.get(1) - 1);
                break;
            }
            case "GAUCHE": {
                newHead.set(0, newHead.get(0) - 1);
                break;
            }
            case "DROITE": {
                newHead.set(0, newHead.get(0) + 1);
            }
        }
        return newHead;
    }

    @Override
    public boolean move(boolean grow) {
        this.evaluate();
        return super.move(grow);
    }
}

