/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;

public class Channel {
    private final String channel_name;
    private Queue<byte[]> events = new ArrayDeque<byte[]>();
    private int id = 0;
    private static final String addr = "https://prog-reseau-m1.lacl.fr/padiflac/";
    private static final String nonce = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final Random r = new Random();

    private String genNonce() {
        char[] sb = new char[64];
        for (int i = 0; i < 64; ++i) {
            sb[i] = nonce.charAt(r.nextInt(62));
        }
        return new String(sb);
    }

    public Channel(String channel_name) {
        this.channel_name = channel_name;
    }

    private byte[] serializeToString(String o) throws IOException {
        return o.getBytes();
    }

    private void parseEvent(byte[] bb, int i) {
        byte b;
        StringBuilder sb = new StringBuilder();
        while (i < bb.length && (b = bb[i]) != 124) {
            sb.append((char)b);
            ++i;
        }
        if (++i < bb.length) {
            int size = Integer.parseInt(sb.toString());
            byte[] buff = Arrays.copyOfRange(bb, i, i + size);
            this.events.add(buff);
            this.parseEvent(bb, i + size);
        } else {
            this.id = Integer.parseInt(sb.toString());
        }
    }

    public void connect() {
        String id2 = "";
        if (this.id > 0) {
            id2 = "?id=" + this.id;
        }
        try {
            URL u = new URL(addr + this.channel_name + id2);
            URLConnection uc = u.openConnection();
            InputStream is = uc.getInputStream();
            byte[] bs = is.readAllBytes();
            this.parseEvent(bs, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getNext() {
        while (this.events.isEmpty()) {
            this.connect();
        }
        return new String(this.events.poll());
    }

    public void send(String s) {
        try {
            String non = this.genNonce();
            URL u = new URL(addr + this.channel_name + "?nonce=" + non);
            HttpsURLConnection uc = (HttpsURLConnection)u.openConnection();
            uc.setRequestMethod("POST");
            uc.setDoOutput(true);
            OutputStream os = uc.getOutputStream();
            os.write(this.serializeToString(s));
            os.close();
            uc.connect();
            uc.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void test() {
        Channel c = new Channel("PippoTest");
        c.connect();
        long time = new Date().getTime();
        c.send(Objects.toString(time));
        c.send("TestJavaObjectToto" + time);
        boolean flag = false;
        long l1 = 0L;
        while (true) {
            String s = c.getNext();
            try {
                l1 = Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (l1 == time) {
                flag = true;
            }
            if (!flag) continue;
            System.out.println(s);
        }
    }

    public static void main(String[] args) {
        Channel.test();
    }
}

