/*
 * Decompiled with CFR 0.152.
 */
package com.mygdx.game;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.mygdx.game.Assets;
import com.mygdx.game.Board;
import com.mygdx.game.IAG20;
import com.mygdx.game.NetworkingUPEC;
import com.mygdx.game.Objects;
import com.mygdx.game.Scene;
import com.mygdx.game.Snake;
import java.util.ArrayList;
import java.util.HashMap;

public class SnakeBlockade
extends ApplicationAdapter {
    SpriteBatch batch;
    Assets assets;
    Scene scene;
    NetworkingUPEC net;
    Board board;
    Objects objects;
    Snake currentSnake;
    Snake snake1;
    Snake snake2;
    Music music;
    Sound step;
    Sound win;
    Sound loose;
    boolean args;
    String writeArg;
    String readArg;
    String playerArg;
    int coups = 0;
    int lapWithoutStrawberry = 0;
    int lapWithoutGrow = 1;
    float soundVolume = 1.0f;
    HashMap<Snake, Boolean> haveToGrow;
    boolean gameOver = false;
    boolean justGameOver = false;

    SnakeBlockade(boolean args, String writeArg, String readArg, String playerArg) {
        this.args = args;
        this.writeArg = writeArg;
        this.readArg = readArg;
        this.playerArg = playerArg;
    }

    public void create() {
        this.batch = new SpriteBatch();
        this.assets = new Assets();
        this.scene = new Scene(this.batch, this.assets);
        this.net = new NetworkingUPEC();
        this.music = (Music)this.assets.get("music/music.mp3", Music.class);
        this.music.setLooping(true);
        this.music.setVolume(0.07f);
        this.music.play();
        this.step = (Sound)this.assets.get("music/step.wav", Sound.class);
        this.win = (Sound)this.assets.get("music/win.wav", Sound.class);
        this.loose = (Sound)this.assets.get("music/loose.wav", Sound.class);
        if (this.args) {
            this.scene.radioGroup.setChecked("[EN LIGNE] IA VS IA");
            this.scene.codeChannelWrite = this.writeArg;
            this.scene.codeChannelRead = this.readArg;
            if (Integer.parseInt(this.playerArg) == 1) {
                this.scene.playerGroup.setChecked("J1 (2, 2)");
            } else {
                this.scene.playerGroup.setChecked("J2 (9, 19)");
            }
            this.scene.startGameButtonActions();
        }
    }

    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.scene.drawBoard();
        if (this.scene.playButtonPressed) {
            this.initNewGame();
        }
        this.manageInput();
        if (this.scene.gameOn || this.gameOver) {
            this.netUpdateOtherSnake();
            this.objects.drawObjects();
            this.snake1.drawSnake();
            this.snake2.drawSnake();
            this.scene.drawCross();
            this.checkGameOver();
            this.checkSnakeBlocked();
            this.updateStrawberrySpawning();
            this.updateSnakesGrowth();
        }
        this.scene.drawBan();
        if (this.scene.menuToggle) {
            this.scene.menuDesign();
        }
        this.batch.end();
    }

    public void initNewGame() {
        this.board = new Board(this.scene);
        this.objects = new Objects(this.batch, this.assets, this.scene, this.board);
        this.objects.objectsEnabled = this.scene.selectedMod.equals("JVJ");
        this.objects.initObjects((this.scene.min + this.scene.max) / 2 / 8, (int)((double)((this.scene.min + this.scene.max) / 2) / 1.5));
        switch (this.scene.selectedMod) {
            case "JVJ": {
                this.JVJRules();
                break;
            }
            case "JVIA": {
                this.JVIARules();
                break;
            }
            case "IAVIA": {
                this.IAVIARules();
            }
        }
        this.coups = 0;
        this.scene.playButtonPressed = false;
        this.lapWithoutStrawberry = 0;
        this.lapWithoutGrow = 1;
        this.gameOver = false;
        this.justGameOver = false;
    }

    public void manageInput() {
        if (this.scene.gameOn && !this.scene.menuToggle && !(this.currentSnake instanceof IAG20) && !this.net.netActivated) {
            if (Gdx.input.isKeyJustPressed(51) || Gdx.input.isKeyJustPressed(19)) {
                this.actionsMove("HAUT");
            }
            if (Gdx.input.isKeyJustPressed(32) || Gdx.input.isKeyJustPressed(22)) {
                this.actionsMove("DROITE");
            }
            if (Gdx.input.isKeyJustPressed(47) || Gdx.input.isKeyJustPressed(20)) {
                this.actionsMove("BAS");
            }
            if (Gdx.input.isKeyJustPressed(29) || Gdx.input.isKeyJustPressed(21)) {
                this.actionsMove("GAUCHE");
            }
        } else if (this.scene.gameOn && this.currentSnake instanceof IAG20 && (!this.net.netActivated || this.net.myTurn)) {
            this.actionsMove("HAUT");
        }
        if (Gdx.input.isKeyJustPressed(111)) {
            this.scene.menuToggle = !this.scene.menuToggle;
            this.scene.firstMenuToggle = true;
        }
        if (Gdx.input.justTouched()) {
            float y;
            float x = Gdx.input.getX();
            if (this.scene.menu.contains(x, y = (float)(Gdx.graphics.getHeight() - Gdx.input.getY()))) {
                this.scene.menuToggle = !this.scene.menuToggle;
                this.scene.firstMenuToggle = true;
            }
            if (this.scene.sound.contains(x, y)) {
                boolean bl = this.scene.isSoundOn = !this.scene.isSoundOn;
                if (this.scene.isSoundOn) {
                    this.music.setVolume(0.07f);
                    this.soundVolume = 1.0f;
                } else {
                    this.music.setVolume(0.0f);
                    this.soundVolume = 0.0f;
                }
            }
        }
    }

    public void actionsMove(String direction) {
        this.currentSnake.setDirection(direction);
        this.gameOver = this.justGameOver = !this.currentSnake.move(this.haveToGrow.get(this.currentSnake));
        this.step.play(this.soundVolume);
        ++this.coups;
        if (this.coups >= 2) {
            ++this.lapWithoutStrawberry;
            ++this.lapWithoutGrow;
            this.coups -= 2;
        }
        this.haveToGrow.replace(this.currentSnake, false);
        Snake otherSnake = this.getOtherSnake();
        if (otherSnake instanceof IAG20) {
            ((IAG20)otherSnake).otherSnake = this.currentSnake;
        }
        if (this.net.netActivated) {
            if (this.net.myTurn) {
                if (this.gameOver) {
                    this.net.writeChannel.send(this.net.directionToLetter(this.currentSnake.gameOverDirection));
                } else {
                    this.net.writeChannel.send(this.net.directionToLetter(this.currentSnake.direction));
                }
            }
            this.net.myTurn = !this.net.myTurn;
        }
        this.changeSnake();
    }

    public void setGameOver() {
        this.scene.gameOn = false;
        this.scene.menuToggle = true;
        this.scene.firstMenuToggle = true;
        if (this.currentSnake == this.snake1) {
            this.scene.playerWon = this.snake2.side;
            this.scene.mainText = this.snake2.name + " wins!";
            this.loose.play(this.soundVolume);
        } else {
            this.scene.playerWon = this.snake1.side;
            this.scene.mainText = this.snake1.name + " wins!";
            this.win.play(this.soundVolume);
        }
        if (this.net.netActivated) {
            this.net.stopChannel();
        }
    }

    public void netUpdateOtherSnake() {
        if (this.net.netActivated && !this.net.myTurn && this.net.receivedSomething) {
            this.net.receivedSomething = false;
            if (this.net.direction.equals("INVALID")) {
                this.gameOver = true;
                this.setGameOver();
                this.scene.mainText = "Coup ill\u00e9gal! " + this.scene.mainText;
                this.scene.crossList.clear();
            } else {
                this.actionsMove(this.net.direction);
            }
        }
    }

    public void checkGameOver() {
        if (this.justGameOver) {
            this.justGameOver = false;
            this.gameOver = true;
            this.changeSnake();
            this.addCross(this.currentSnake.futureHead(this.currentSnake.gameOverDirection));
            this.setGameOver();
        }
    }

    public void checkSnakeBlocked() {
        if (this.currentSnake.isBlocked(this.haveToGrow.get(this.currentSnake)) && !this.gameOver) {
            this.gameOver = true;
            this.crossIsBlocked();
            this.setGameOver();
        }
    }

    public void updateStrawberrySpawning() {
        if (this.lapWithoutStrawberry >= 8) {
            this.objects.addStrawberry();
            this.lapWithoutStrawberry = 0;
        }
    }

    public void updateSnakesGrowth() {
        if (this.lapWithoutGrow >= this.scene.n) {
            this.haveToGrow.replace(this.snake1, true);
            this.haveToGrow.replace(this.snake2, true);
            this.lapWithoutGrow = 0;
        }
    }

    public void changeSnake() {
        this.currentSnake = this.currentSnake == this.snake1 ? this.snake2 : this.snake1;
        this.scene.isLeftPlaying = !this.scene.isLeftPlaying;
    }

    public Snake getOtherSnake() {
        if (this.currentSnake == this.snake1) {
            return this.snake2;
        }
        return this.snake1;
    }

    public void crossIsBlocked() {
        this.addCross(this.currentSnake.futureHead("HAUT"));
        this.addCross(this.currentSnake.futureHead("DROITE"));
        this.addCross(this.currentSnake.futureHead("BAS"));
        this.addCross(this.currentSnake.futureHead("GAUCHE"));
    }

    public void addCross(ArrayList<Integer> pos) {
        ArrayList<Float> newPos = new ArrayList<Float>();
        newPos.add(Float.valueOf(pos.get(0).intValue()));
        newPos.add(Float.valueOf(pos.get(1).intValue()));
        if (this.board.outsideLimits.contains(pos)) {
            if (((Float)newPos.get(0)).floatValue() < 0.0f) {
                newPos.set(0, Float.valueOf(-0.5f));
            } else if (((Float)newPos.get(0)).floatValue() > (float)(this.scene.columns - 1)) {
                newPos.set(0, Float.valueOf((float)(this.scene.columns - 1) + 0.5f));
            } else if (((Float)newPos.get(1)).floatValue() < 0.0f) {
                newPos.set(1, Float.valueOf(-0.5f));
            } else if (((Float)newPos.get(1)).floatValue() > (float)(this.scene.lines - 1)) {
                newPos.set(1, Float.valueOf((float)(this.scene.lines - 1) + 0.5f));
            }
        }
        this.scene.crossList.add(newPos);
    }

    public void JVJRules() {
        this.snake1 = new Snake(this.batch, this.assets, this.scene, this.board, this.objects, "LEFT");
        this.snake1.name = "J1";
        this.snake2 = new Snake(this.batch, this.assets, this.scene, this.board, this.objects, "RIGHT");
        this.snake2.name = "J2";
        this.scene.setPlayersNames(this.snake1.name, this.snake2.name);
        this.snake1.initSnake();
        this.snake2.initSnake();
        this.currentSnake = this.snake1;
        this.haveToGrow = new HashMap<Snake, Boolean>(){
            {
                this.put(SnakeBlockade.this.snake1, false);
                this.put(SnakeBlockade.this.snake2, false);
            }
        };
    }

    public void JVIARules() {
        this.snake1 = new Snake(this.batch, this.assets, this.scene, this.board, this.objects, "LEFT");
        this.snake1.name = "J1";
        this.snake2 = new IAG20(this.batch, this.assets, this.scene, this.board, this.objects, "RIGHT");
        this.snake2.name = "IAG20";
        ((IAG20)this.snake2).otherSnake = this.snake1;
        this.scene.setPlayersNames(this.snake1.name, this.snake2.name);
        this.snake1.initSnake();
        this.snake2.initSnake();
        this.currentSnake = this.snake1;
        this.haveToGrow = new HashMap<Snake, Boolean>(){
            {
                this.put(SnakeBlockade.this.snake1, false);
                this.put(SnakeBlockade.this.snake2, false);
            }
        };
    }

    public void IAVIARules() {
        if (this.scene.onlinePlayFirst) {
            this.snake1 = new IAG20(this.batch, this.assets, this.scene, this.board, this.objects, "LEFT");
            this.snake2 = new Snake(this.batch, this.assets, this.scene, this.board, this.objects, "RIGHT");
            this.snake1.name = "IAG20";
            this.snake2.name = "IA";
            ((IAG20)this.snake1).otherSnake = this.snake2;
        } else {
            this.snake1 = new Snake(this.batch, this.assets, this.scene, this.board, this.objects, "LEFT");
            this.snake2 = new IAG20(this.batch, this.assets, this.scene, this.board, this.objects, "RIGHT");
            this.snake1.name = "IA";
            this.snake2.name = "IAG20";
            ((IAG20)this.snake2).otherSnake = this.snake1;
        }
        this.scene.setPlayersNames(this.snake1.name, this.snake2.name);
        this.snake1.initSnakeTournament();
        this.snake2.initSnakeTournament();
        this.currentSnake = this.snake1;
        this.haveToGrow = new HashMap<Snake, Boolean>(){
            {
                this.put(SnakeBlockade.this.snake1, false);
                this.put(SnakeBlockade.this.snake2, false);
            }
        };
        this.objects.addRocksTournament();
        this.net.startChannel(this.scene.codeChannelRead, this.scene.codeChannelWrite, this.scene.onlinePlayFirst);
        this.net.reader.start();
    }

    public void dispose() {
        this.batch.dispose();
        this.assets.dispose();
        this.scene.dispose();
    }
}

